<div class="colaborator">

    <div class="colaborator-list">
        <?php

        $args = array(
            'post_type' => 'colaborador',
            'post_status' => 'publish',
            'meta_query' => array(
                array(
                    'key'     => 'can_home',
                    'value'   => 'true',
                    'compare' => '=',
                )
            ),
            'orderby' => 'rand',
            'posts_per_page' => 7,
        );

        if (get_query_var('is_school')) {
            $args = array(
                'post_type' => 'colaborador',
                'post_status' => 'publish',
                'posts_per_page' => 7,
                'orderby' => 'rand',
                'meta_query' => array(
                    'relation' => 'OR',
                    array(
                        'key'     => 'school',
                        'value'   => '-1',
                        'compare' => '=',
                    ),
                    array(
                        'key'     => 'school',
                        'value'   => get_the_ID(),
                        'compare' => '=',
                    ),
                )
            );
        }
        $query = new WP_Query($args);

        while ($query->have_posts()) :
            $query->the_post();
            $image = get_field('image');
            $name = get_field('name');
            $post_name = null;
            if (get_field('school') != -1) {
                $post_name = get_post(get_field('school'));
                $post_name = $post_name->post_title;
            }
            global $currentday;
            ?>
            <div class="colaborator">
                <img src="<?php echo $image ?>" alt="<?php echo $name ?>" />
            </div>
        <?php endwhile;
        wp_reset_postdata(); ?>

    </div>

</div>