<?php
  $idProduct = get_the_ID();

  if ( have_rows('contenido_flexible', $idProduct) ) :
  ?>

  <div class="flexible-content">

  <?php
    while ( have_rows('contenido_flexible') ) : the_row();

      if( get_row_layout() == 'texto_contenido_flexible' ):
      ?>
      <div class="element-content content-text">
        <?php echo the_sub_field('texto_contenido_flexible_elemento'); ?>
      </div>
      <?php
      elseif( get_row_layout() == 'imagen_contenido_flexible' ): 
        $image = get_sub_field('imagen_contenido_flexible_elemento');
      ?>
      <div class="element-content content-image">
        <img src="<?php echo $image; ?>" />
      </div>
      <?php
      elseif( get_row_layout() == 'video_contenido_flexible' ): 
        $video = get_sub_field('video_contenido_flexible_elemento');
      ?>
      <div class="element-content content-video">
        <?php echo $video; ?>
      </div>
      <?php
      elseif( get_row_layout() == 'galeria_contenido_flexible' ):
        $galerries = array('content-gallery' => get_sub_field('galeria_contenido_flexible_elemento'));
        ?>
        <div class="element-content content-gallery">
            <div class="row no-gutters">
                <?php foreach (array_values($galerries)[0] as $img): ?>
                    <div class="content-gallery-item col-12 col-md-6 mb-1">
                        <div class="back-image" style="background-image: url('<?php echo $img['url']; ?>')">
                            <a href="<?php echo $img['url']; ?>" data-fancybox="<?php echo array_keys($galerries)[0]; ?>">
                                <img src="<?php echo $img['url']; ?>" />
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif;

    endwhile;
?>

  </div>

<?php
  endif;
?>