<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

?>

</div><!-- #content -->

<footer id="colophon" class="site-footer" role="contentinfo">
	
	<div class="menu-footer-contact">
		<div class="container">
			<div class="contact-info">
				<h4>Contacta con nosotros</h4>
				<p>Si desea ampliar la información, estaremos encantados de enseñarle nuestras instalaciones.</p>
				<p>Póngase en contacto con nosotros y le atenderemos personalmente.</p>
				<p>Si desea trabajar con nosotros y enviarnos su currículum personal, pinche aquí.</p>
			</div>

			<div class="contact-form">
				<?php echo do_shortcode('[contact-form-7 id="6" title="Formulario de contacto 1"]'); ?>
			</div>
		</div>
	</div>


	<div class="menu-footer">
		<div class="container">
			<div class="row-menu">
				<p class="footer-title"><?php pll_e("Colegios") ?></p>

				<?php if (has_nav_menu('footer-schools')) :  ?>
					<div class="footer-schools">
						<div class="list-container">

							<?php wp_nav_menu(array('theme_location' => 'footer-schools')); ?>

						</div>
					</div>
				<?php endif; ?>
			</div>
			<div class="row-menu">
				<p class="footer-title"><?php pll_e("Institución") ?></p>
				<?php if (has_nav_menu('footer-institution')) :  ?>
					<div class="footer-institution">
						<div class="list-container">

							<?php wp_nav_menu(array('theme_location' => 'footer-institution')); ?>

						</div>
					</div>
				<?php endif; ?>
			</div>
			<div class="row-menu">
				<p class="footer-title"><?php pll_e("Modelo Educativo") ?></p>
				<?php if (has_nav_menu('footer-education')) :  ?>
					<div class="footer-education">
						<div class="list-container">

							<?php wp_nav_menu(array('theme_location' => 'footer-education')); ?>

						</div>
					</div>
				<?php endif; ?>
			</div>
			<div class="row-menu">
				<p class="footer-title"><?php pll_e("Colegio Bilingüe") ?></p>
				<?php if (has_nav_menu('footer-bilungual')) :  ?>
					<div class="footer-bilungual">
						<div class="list-container">

							<?php wp_nav_menu(array('theme_location' => 'footer-bilungual')); ?>

						</div>
					</div>
				<?php endif; ?>
			</div>
			<div class="row-menu">
				<p class="footer-title"><?php pll_e("Servicios") ?></p>
				<?php if (has_nav_menu('footer-services')) :  ?>
					<div class="footer-services">
						<div class="list-container">

							<?php wp_nav_menu(array('theme_location' => 'footer-services')); ?>

						</div>
					</div>
				<?php endif; ?>
			</div>
			<div class="row-menu">
				<p class="footer-title"><?php pll_e("Al día") ?></p>
				<?php if (has_nav_menu('footer-schedule')) :  ?>
					<div class="footer-schedule">
						<div class="list-container">

							<?php wp_nav_menu(array('theme_location' => 'footer-schedule')); ?>

						</div>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>

	<div class="legal-info">
		<div class="container">
			<div class="legal-left">
				<img src="<?php get_field('logo', 'options') ?>" alt="Aquí iria el logo">

			</div>
			<div class="legal-right">
				<div class="legal-up">
					<p><?php get_field('legal-text', 'options') ?></p>
					<div class="menu-legal">
						<?php wp_nav_menu(array('theme_location' => 'legal-menu')); ?>
					</div>
				</div>

			</div>
		</div>
	</div>
</footer><!-- #colophon -->
</div><!-- .site-content-contain -->
</div><!-- #page -->
<?php wp_footer(); ?>

</body>

</html>