<div class="news">

    <div class="news-grid">
        <?php

        $args = array(
            'post_type' => 'news',
            'post_status' => 'publish',
            'posts_per_page' => 6
        );

        if (get_query_var('is_school')) {
            $args = array(
                'post_type' => 'news',
                'post_status' => 'publish',
                'posts_per_page' => 6,
                'meta_query' => array(
                    'relation' => 'OR',
                    array(
                        'key'     => 'school',
                        'value'   => '-1',
                        'compare' => '=',
                    ),
                    array(
                        'key'     => 'school',
                        'value'   => get_the_ID(),
                        'compare' => '=',
                    ),
                )
            );
        }
        $query = new WP_Query($args);

        while ($query->have_posts()) :
                $query->the_post();
                $image = get_field('image_preview');
                $post_name = null;
                if(get_field('school') != -1){
                    $post_name = get_post(get_field('school'));
                    $post_name = $post_name->post_title;
                }

            ?>
            <div class="new">
                <div class = "new-image">
                    <img src = "<?php if($image) echo $image ?>" alt="No hay imagen">
                </div>
                <div class = "new-content">
                    <div class ="new-up">
                        <span class="new-centro"><?php if($post_name) echo $post_name ?></span>
                        <span><?php the_date() ?></span>
                    </div>
                    <div class ="new-down">
                        <a href="<?php the_permalink() ?>"><h6><?php the_title()?></h6></a>
                    </div>
                </div>
            </div>
        <?php endwhile;
        wp_reset_postdata(); ?>

    </div>

    <div class="news-btn-bottom">
        <a class="btn-primary" href="#">Ver más</a>
    </div>

</div>