<div class="agencies">
    <h4>Agenda</h4>
    <div class="agencies-list">
        <?php

        $args = array(
            'post_type' => 'agenda',
            'post_status' => 'publish',
            'posts_per_page' => 4
        );

        if (get_query_var('is_school')) {
            $args = array(
                'post_type' => 'agenda',
                'post_status' => 'publish',
                'posts_per_page' => 4,
                'meta_query' => array(
                    'relation' => 'OR',
                    array(
                        'key'     => 'school',
                        'value'   => '-1',
                        'compare' => '=',
                    ),
                    array(
                        'key'     => 'school',
                        'value'   => get_the_ID(),
                        'compare' => '=',
                    ),
                )
            );
        }
        $query = new WP_Query($args);

        while ($query->have_posts()) :
            $query->the_post();
            $image = get_field('image_preview');
            $date_string = get_field('date_display');
            setlocale(LC_ALL,'es_ES');
            $date =  date('mdY',strtotime($date_string) );
            
            $date =  DateTime::createFromFormat('dmY',$date);
            
            
            $post_name = null;
            if (get_field('school') != -1) {
                $post_name = get_post(get_field('school'));
                $post_name = $post_name->post_title;
            }
            global $currentday;
            ?>
            <div class="agency">
                <div class="date">
                    <span class="day"><?php echo $date->format('d') ?></span>
                    <span class="month"> <?php echo  $date->format('M') ?></span>
                </div>
                <div class="agency-content">
                    <div class="agency-up">
                        <h6><?php the_title() ?></h6>
                    </div>
                    <div class="agency-down">
                        <span><?php if ($post_name) echo $post_name ?></span>
                        <a href="<?php the_permalink() ?>">Ver más </a>
                    </div>
                </div>
            </div>
        <?php endwhile;
        wp_reset_postdata(); ?>

    </div>

    <div class="agency-btn-bottom">
        <a class="btn-primary" href="#">Ver Agenda</a>
    </div>

</div>