<div class="opinions">
    <div class="container">
        <h4 class="title"><?php pll_e('Hablan de Nosotros') ?></h4>
        <div class="opinion-list">
            <?php

            $args = array(
                'post_type' => 'opinion',
                'post_status' => 'publish',
                'orderby' => 'rand',
                'posts_per_page' => 2,
            );

            if (get_query_var('is_school')) {
                $args = array(
                    'post_type' => 'opinion',
                    'post_status' => 'publish',
                    'posts_per_page' => 2,
                    'orderby' => 'rand',
                    'meta_query' => array(
                        'relation' => 'OR',
                        array(
                            'key'     => 'school',
                            'value'   => '-1',
                            'compare' => '=',
                        ),
                        array(
                            'key'     => 'school',
                            'value'   => get_the_ID(),
                            'compare' => '=',
                        ),
                    )
                );
            }
            $query = new WP_Query($args);

            while ($query->have_posts()) :
                $query->the_post();
                $image = get_field('image');
                $name = get_field('name');
                $opinion = get_field('opinion');
                $profesion = get_field('position');
                $post_name = null;
                if (get_field('school') != -1) {
                    $post_name = get_post(get_field('school'));
                    $post_name = $post_name->post_title;
                }
                global $currentday;
                ?>
                <div class="opinion">
                    <div class="opinion-photo">
                        <img src="<?php echo $image ?>" alt="<?php echo $name ?>" />
                    </div>
                    <div class="opinion-text">
                        <div class="opinion-description">
                            <span><?php if($opinion) echo $opinion ?></span>
                        </div>
                        <div class="opinion-name">
                            <span><?php if($name) echo $name ?></span>
                        </div>
                        <div class="opinion-profesion">
                            <span><?php if($profesion) echo $profesion ?></span>
                        </div>
                    </div>
                </div>
            <?php endwhile;
            wp_reset_postdata(); ?>

        </div>
    </div>
</div>